/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish.entity.goals;

import com.hollingsworth.mother_silverfish.ModUtil;
import com.hollingsworth.mother_silverfish.entity.BabyFish;
import com.hollingsworth.mother_silverfish.entity.MotherSilverfishEntity;
import com.hollingsworth.mother_silverfish.event.EarthquakeEvent;
import com.hollingsworth.mother_silverfish.event.EventQueue;
import com.hollingsworth.mother_silverfish.network.Networking;
import com.hollingsworth.mother_silverfish.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class EarthquakeGoal
extends Goal {
    MotherSilverfishEntity boss;
    Supplier<Boolean> canUse;
    int ticks;
    boolean isDone;
    boolean slammed;
    boolean startedQuake;
    BlockPos targetPos;

    public EarthquakeGoal(MotherSilverfishEntity motherSilverfishEntity, Supplier<Boolean> canUse) {
        this.boss = motherSilverfishEntity;
        this.canUse = canUse;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void m_8037_() {
        if (!this.slammed) {
            Networking.sendToNearby(this.boss.f_19853_, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.m_142049_(), MotherSilverfishEntity.Animations.EARTHQUAKE.ordinal()));
            this.slammed = true;
        }
        ++this.ticks;
        if (this.ticks >= 20 && !this.startedQuake) {
            if (this.boss.m_5448_() != null) {
                EventQueue.getServerInstance().addEvent(new EarthquakeEvent(this.boss.f_19853_, () -> this.boss.m_20097_(), () -> {
                    if (this.boss.m_5448_() != null) {
                        double xSlope = (double)this.targetPos.m_123341_() - this.boss.m_20185_();
                        double zSlope = (double)this.targetPos.m_123343_() - this.boss.m_20189_();
                        return this.targetPos.m_142022_(xSlope * 2.0, 0.0, zSlope * 2.0);
                    }
                    return null;
                }));
            }
            for (Entity e : this.boss.f_19853_.m_45933_(null, this.boss.m_142469_().m_82377_(5.0, 5.0, 5.0))) {
                if (!(e instanceof LivingEntity) || e instanceof BabyFish || e instanceof MotherSilverfishEntity) continue;
                e.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 12.0f);
            }
            this.startedQuake = true;
        }
        if (this.boss.m_5448_() != null) {
            this.boss.m_21563_().m_148051_((Entity)this.boss.m_5448_());
        }
        this.boss.m_20334_(0.0, 0.0, 0.0);
        if (this.ticks > 60) {
            this.finishEarthquake();
        }
    }

    public void finishEarthquake() {
        this.isDone = true;
        this.boss.earthquakeCooldown = this.boss.getEarthquakeCooldown();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.ticks = 0;
        this.isDone = false;
        this.slammed = false;
        this.startedQuake = false;
        if (this.boss.m_5448_() != null) {
            this.targetPos = this.boss.m_5448_().m_20097_();
        }
    }

    public boolean m_8045_() {
        return !this.isDone && this.boss.m_5448_() != null;
    }

    public boolean m_8036_() {
        return this.boss.earthquakeCooldown <= 0 && this.canUse.get() != false && this.boss.m_5448_() != null && ModUtil.distanceFrom((Entity)this.boss.m_5448_(), (Entity)this.boss) < 10.0;
    }
}

